close all
clear all
clc

%Maximum and minimum analog voltages that can be applied to board
Anglog_Input_Min=0  %in Volts
Anglog_Input_Max=3  %in Volts
%ADC of board has range of 0-3V from DataSheet

Digital_Output=3.3  %in Volts
%Digital output is 0 or 3.3V from DataSheet

%Reference Signal Characteristics:
Amplitude_Signal=5;   %Signal Amplitude in Volts
Bias_Signal=0;        %Signal offset in Volts
Frequency_Signal=1/2; %Signal Frequency in Hertz

%Filter Characteristics
CutOff_Freq=Frequency_Signal*8

%Simulation time
Sim_time=4

%Sampling Time:
Sampling_Time=0.01 %0.01%80e-9   %sampling and hold,ADC 80ns from DataSheet

%Number of bits:
Bits=12        %12 bits ADC from DataSheet

%Full Scale Reading( Maximum-Minimum):
Full_Scale_Reading=Anglog_Input_Max-Anglog_Input_Min

%PWM Resolution for board
BitsPWM=12;
fclk=150e6;
fpwm=fclk/2^BitsPWM

%PWM Resolution for Simulation
BitsPWM=12;
%fclk=10e4;
fclk=10e4;
fpwm=fclk/2^BitsPWM
tpwm=1/fpwm
tclk=1/fclk

%Signal Dynamic Conditioning:
    %Determining the maxima and the minima of the Reference Signal:
if Bias_Signal~=0
Max_Signal=Amplitude_Signal+Bias_Signal
Min_Signal=0
else
    Max_Signal=Amplitude_Signal+Bias_Signal
    Min_Signal=-Amplitude_Signal+Bias_Signal
end

%Scaling (Adjusting the input of the Reference Signal to board Dynamics
%0-3V
    offSet=sym('offSet','real');
    grad=sym('grad','real');

    eqn=[Anglog_Input_Max-grad*Max_Signal-offSet
        Anglog_Input_Min-Min_Signal*grad-offSet];

    [xG,xO]=solve(eqn==0)
    xO=double(xO)
    xG=double(xG)
    
    offSet1=sym('offSet1','real');
    grad1=sym('grad1','real');

    eqn1=[Max_Signal-grad1*Digital_Output-offSet1
        Min_Signal-Anglog_Input_Min*grad1-offSet1];
    
    [gX,gO]=solve(eqn1==0)
    gO=double(gO)
    gX=double(gX)
